/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0, or the Eclipse Distribution License
 * v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License v2.0
 * w/Classpath exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause OR GPL-2.0 WITH
 * Classpath-exception-2.0
 */

package com.sun.corba.ee.spi.ior ;

import org.omg.CORBA_2_3.portable.InputStream ;
import com.sun.corba.ee.spi.orb.ORB ;

/** Factory interface for creating Identifiables.
 */
public interface IdentifiableFactory<E extends Identifiable> {
    /** Return the id of this factory, which is the id of the result 
     * of any create call.
     * @return factory id
     */
    public int getId() ;

    /** Construct the appropriate Identifiable object with the 
     * given id from the InputStream is.  
     * @param orb ORB to use for creation
     * @param in stream to construct object from
     * @return constructed Identifiable
     */
    public E create( ORB orb, InputStream in ) ;
}
