package junit.extensions.jfcunit;


/**
 * Used to report exit status of classes which call System.exit().
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public final class ExitException extends SecurityException {
    /**
     * Status code.
     */
    private final int m_status;

    /**
     * Constructs an exit exception.
     *
     * @param status the status code returned via System.exit()
     */
    public ExitException(final int status) {
        super("ExitException: status " + status);
        m_status = status;
    }

    /**
     * The status code returned by System.exit().
     *
     * @return the status code returned by System.exit()
     */
    public int getStatus() {
        return m_status;
    }
}
