package junit.extensions.jfcunit.eventdata;

import junit.extensions.jfcunit.xml.JFCXMLConstants;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;

import org.w3c.dom.Element;


/**
 * This element controls the JFCEventManager.
 *
 * <h3>Description</h3>
 * <p>
 *    This class can enable and disable recording and debugging.
 *    As can the JFCEventManager. The API for adding recording listeners
 *    is not exposed via the XML and must be performed via code.
 *    However, the recording and debugging combination allows for the
 *    events received to be displayed to standard out.
 * </p>
 * <p>
 *    In the future, XML script generation will be enabled via this class.
 * </p>
 *
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">debug</td>
 *     <td valign="top">Enable debugging for the test runs.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">false</td>
 *     <td valign="top">true false</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">recording</td>
 *     <td valign="top">Enable recording for the test runs.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">false</td>
 *     <td valign="top">true false</td>
 *   </tr>
 *
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;manager
 *    debug=&quot;true&quot;
 *    recording=&quot;true&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above line truns on recording and debugging to produce the
 * events being sent through the AWTEventQueue. It can be used to
 * analyze direct input via the mouse and keyboard. Or it can be
 * used when pumping events via jfcUnit.
 * </p>
 * @see junit.extensions.jfcunit.eventdata.JFCEventManager
 * @author Kevin Wilson
 */
public class JFCEventManagerTagHandler extends AbstractTagHandler
    implements JFCXMLConstants {
    /**
     * Constructor for AWTThreadTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public JFCEventManagerTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException provided by contract only.
     */
    public void processElement() throws XMLException {
        validateElement();

        JFCEventManager.getEventManager().setDebug(getBoolean(DEBUG));
        JFCEventManager.getEventManager().setRecording(getBoolean(RECORDING));
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     * @throws XMLException provided by contract only.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();
    }
}
