package junit.extensions.jfcunit.xml;

import junit.extensions.jfcunit.eventdata.EventDataConstants;

import junit.extensions.xml.XMLConstants;

import java.awt.Toolkit;


/**
 * This class defines the common tokens which are
 * used in parsing the XML file.
 * @author Kevin Wilson
 */
public interface JFCXMLConstants extends XMLConstants, EventDataConstants {
    /** Alt. */
    String ALT = Toolkit.getProperty("AWT.alt", "Alt");

    /** Alt Graph. */
    String ALTGR = Toolkit.getProperty("AWT.altGraph", "Alt Graph");

    // Wheel

    /** amount. */
    String AMOUNT = "amount";

    // TestCase

    /** assertexit. */
    String ASSERTEXIT = "assertexit";

    /** awtthread. */
    String AWTTHREAD = "awteventqueue";

    /** Button1. */
    String BUTTON1 = Toolkit.getProperty("AWT.button1", "Button1");

    /** Button2. */
    String BUTTON2 = Toolkit.getProperty("AWT.button2", "Button2");

    /** Button3. */
    String BUTTON3 = Toolkit.getProperty("AWT.button3", "Button3");

    /** caseindependent. */
    String CASEINDEPENDENT = "caseindependent";

    /** class. */
    String CLASS = "class";

    /** click. */
    String CLICK = "click";

    /** clicks. */
    String CLICKS = "clicks";

    /** code. */
    String CODE = "code";

    /** container. */
    String CONTAINER = "container";

    /** contains. */
    String CONTAINS = "contains";

    /** Ctrl. */
    String CTRL = Toolkit.getProperty("AWT.control", "Ctrl");

    /** destination. */
    String DESTINATION = "destination";

    /** down. */
    String DOWN = "down";

    /** drag. */
    String DRAG = "drag";

    /** duration. */
    String DURATION = "duration";

    /** editor. */
    String EDITOR = "editor";

    /** endswith. */
    String ENDSWITH = "endswith";

    /** equals. */
    String EQUALS = "equals";

    // Finders

    /** find. */
    String FIND = "find";

    /** finder. */
    String FINDER = "finder";

    /** flush. */
    String FLUSH = "flush";

    /** icondesc. */
    String ICONDESCRIPTION = "icondesc";

    /** iconfile. */
    String ICONFILE = "iconfile";

    /** indexdelimiter. */
    String INDEXDELIMITER = "indexdelimiter";

    /** indexes. */
    String INDEXES = "indexes";

    /** key. */
    String KEY = "key";

    /** label. */
    String LABEL = "label";

    /** match. */
    String MATCH = "match";

    // Modifiers

    /** Meta. */
    String META = Toolkit.getProperty("AWT.meta", "Meta");

    /** modifiers. */
    String MODIFIERS = "modifiers";

    // JTable, JTableHeader
    // JTree

    /** node. */
    String NODEVALUE = "node";

    /** operation. */
    String OPERATION = "operation";

    /** path. */
    String PATH = "path";

    /** pathdelimiter. */
    String PATHDELIMITER = "pathdelimiter";

    /** pause. */
    String PAUSE = "pause";

    /** point. */
    String POINT = "point";

    /** popup. */
    String POPUPTRIGGER = "popup";

    /** position. */
    String POSITION = "position";

    /** recording. */
    String RECORDING = "recording";

    /** reference. */
    String REFERENCE = "reference";

    /** resume. */
    String RESUME = "resume";

    /** robot. */
    String ROBOT = "robot";

    /** rotation. */
    String ROTATION = "rotation";

    /** Shift. */
    String SHIFT = Toolkit.getProperty("AWT.shift", "Shift");

    /** show. */
    String SHOW = "show";

    /** sleep. */
    String SLEEP = "sleep";

    /** terminator. */
    String TERMINATOR = "terminator";

    // Common Event Data

    /** sleeptime. */
    String SLEEPTIME = "sleeptime";

    // Drag

    /** source. */
    String SOURCE = "source";

    /** startswith. */
    String STARTSWITH = "startswith";

    // String event data

    /** string. */
    String STRING = "string";

    // Spinner

    /** sub. */
    String SUBCOMPONENT = "sub";

    /** title. */
    String TITLE = "title";

    /** up. */
    String UP = "up";

    /** wait. */
    String WAIT = "wait";
}
