package junit.extensions.jfcunit.xml;

import junit.extensions.jfcunit.JFCTestHelper;
import junit.extensions.jfcunit.RobotTestHelper;

import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLUtil;

import junit.framework.Test;

import org.w3c.dom.Element;

import java.awt.AWTException;


/**
 * This class will handle the processing of &lt;test&gt; nodes.
 *
 * <h3>Description</h3>
 * <p>
 *   This tag handler invokes the test case given.
 * </p>
 *
 * <h3>Attributes</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">name</td>
 *     <td valign="top">name of the test case</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">Alpha Numeric Name</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">robot</td>
 *     <td valign="top">Use a robot or send events directly to AWT Event queue.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">false</td>
 *     <td valign="top">true if events are to be sent via the Robot</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">assertexit</td>
 *     <td valign="top">
 *        Assert the System.exit() command, ExitException will be thrown
 *        by the security manager and the application will not exit.
 *     </td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">false</td>
 *     <td valign="top">true if the system exist should be asserted.</td>
 *   </tr>
 * </table>
 * <h3>Example</h3>
 * <pre>
 * &lt;test name="Login"&gt
 * ...
 * &lt;/test&gt;
 * &lt;test name="Logout" assertexit="true"&gt;
 * ...
 * &lt;/test&gt;
 * </pre>
 * <p>
 * The above runs the defined testcase.
 * </p>
 * @author Kevin Wilson
 */
public class TestTagHandler extends junit.extensions.xml.elements.TestTagHandler
    implements JFCXMLConstants {
    /**
     * Constructor for TestTagHandler.
     *
     * @param element     The element to be processed
     * @param testSuite    The IXMLTestCase that uses this element
     */
    public TestTagHandler(final Element element, final IXMLTestSuite testSuite) {
        super(element, testSuite);
    }

    /**
     * Get the current test as a JFCXMLTestCase.
     * @return JFCXMLTestCase Test Case.
     */
    public final JFCXMLTestCase getJFCTest() {
        return (JFCXMLTestCase) m_testCase;
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException upon validation error.
     */
    public void processElement() throws XMLException {
        validateElement();

        // for each test, the found objects map on the test case has to be reset
        Element        element = getElement();
        JFCXMLTestCase tc = getJFCTest();

        /** @todo: Need to support a helperClass attribute which might use a totally new sub-class of TestHelper...*/
        boolean robot = XMLUtil.getBooleanAttributeValue(element, ROBOT);

        if (robot) {
            try {
                tc.setHelper(new RobotTestHelper());
            } catch (AWTException ex) {
                tc.setHelper(new JFCTestHelper());
            }
        } else {
            tc.setHelper(new JFCTestHelper());
        }

        boolean assertExit = XMLUtil.getBooleanAttributeValue(element,
                ASSERTEXIT);
        tc.setAssertExit(assertExit);
        super.processElement();
    }

    /**
     * Create a JFCXmlTestCase.
     * @return Test new instance.
     */
    protected Test createTest() {
        return new JFCXMLTestCase(
            getName(),
            getElement());
    }
}
