package junit.extensions.xml;

import junit.framework.Test;


/**
 * Test Case for running XML Script based testing.
 *
 * @author Kevin Wilson
 */
public interface IXMLTest extends Test {
    /**
     * get the debug state.
     * @return true if debugging is enabled.
     */
    boolean getDebug();

    /**
     * set the Parent test case.
     * @param parent Parent test case.
     */
    void setParent(final IXMLTest parent);

    /**
     * Get the XML procedure by the name given.
     * @param name Name of the procedure.
     * @return Procedure.
     */
    IXMLProcedure getProcedure(final String name);

    /**
     * Retrun the cache of procedures.
     * @return XMLObjectCache used to hold the procedures.
     */
    XMLObjectCache getProcedureCache();

    /**
     * Retrieve the object that was found previously.
     *
     * @param name    The name of the object that was found.
     * @return    The object to be retrieved.
     */
    Object getProperty(final String name);

    /**
     * Get the Found object cache.
     * @return XMLObjectCahce
     */
    XMLObjectCache getPropertyCache();

    /**
     * Retrieve the name of a object which was previously found.
     * @param comp   Component which is to be found.
     * @return Name of the component.
     */
    String getPropertyName(final Object comp);

    /**
     * Get the names of the found objects.
     * @return array containing the names of the objects.
     */
    String[] getPropertyNames();

    /**
     * Adds a XML Procedure to the test sutie.
     * @param proc Procedure to be added.
     */
    void addProcedure(final IXMLProcedure proc);

    /**
     * Add each found object into the cache map.
     *
     * @param name    The name of the found object.
     * @param obj     The actual object that was found.
     */
    void addProperty(final String name, final Object obj);

    /**
     * For each test (method) element, the found objects
     * has to be cleared.
     */
    void clearProperties();

    /**
     * Remove the property by name.
     * @param name Name of the property to be removed.
     */
    void removeProperty(final String name);

    /**
     * Resolve embeded property values.
     * @param value Value which may contain properties
     * to be resolved.
     * @return String without property names.
     */
    String resolveProperties(String value);
}
